/*  GkrellmWHO2 plugin
 *  Copyright (C) 2003 Alexander Shishckin
 *
 *  Author:  Alexander Shishckin <shisha@shisha.spb.ru>
 *
 *  This program is free software which I release under the GNU General Public
 *  License. You may redistribute and/or modify this program under the terms
 *  of that license as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  To get a copy of the GNU General Puplic License,  write to the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __GKRELLMWHO2_H__
#define __GKRELLMWHO2_H__
/*
 * Definitions for gkrellmwho2 plugin
 */

#define GKRELLMWHO2_VERSION_MAJOR 1
#define GKRELLMWHO2_VERSION_MINOR 0
#define GKRELLMWHO2_VERSION_REV   0

#define	CONFIG_NAME	"GkrellmWHO2"

#define	STYLE_NAME	"GkrellmWHO2"

#define MAX_STRING_LEN 256
#define MAX_COLORS 8
#define MAX_USERS 32
#define MAX_LINES 48
#define NONE_MSG "no users"
#define MONITOR_CONFIG_KEYWORD  "who2"

/* Sort switch */
#define	by_name 1
#define	by_idle 2

typedef int sortfn (const void *, const void *);

typedef struct {
	char				*name;
	char				*usr_str;
	int					usr_str_width;
	unsigned int		count;
	unsigned int		offset;
	time_t				idle_time;
	GkrellmTextstyle	*text_style;
}	WhoUser;

WhoUser	*users[MAX_USERS];
WhoUser	*cache[MAX_USERS];

static gchar	*user_tips_text = NULL; 
static gchar	default_msg[MAX_STRING_LEN];
static gint		default_msg_width;

const gchar	*status[3] = { "act", "away", "gone" };

/* Plugin settings */
static gint	name_only = 0;
static gint	show_status = 1;
static gint	exclude_me = 0;
static gint	group_by_status = 1;
static gint	sort_by = by_name;
static gchar	*no_users = NULL;
static gint	frequency = 5;		/* Seconds between krell updates */
static gint	scroll_speed = 3;	/* Scroll speed in pixels */
static gint	user_count = 0;
static gint	users_xoff;
static gint	x_scroll;
static gint	w;
static gint	button1_down = FALSE;
static gint	drag_line = FALSE;
static time_t	away_time = 600;	/* Idle time, after which user is considered away */
static time_t	gone_time = 1800;	/* or gone. Both in seconds */
static gchar	*log_name;			/* Current user's login name */
static gchar	notify_command[MAX_STRING_LEN];
static gint	notify_once = 1;
static gint notify_ran = 0;

/* Everybody's got something to hide except me and my monkey */
gchar		*plugin_info_text[] = {
	"<h>Gkrellm WHO2 Plugin\n\n",
	"This plugin displays currently logged users on the system except you.\n",
	"It also shows number of logins for each username and may show idle status.\n\n",
	"<h>User interface:\n\n",
	"The krell appears just above the mail monitor as a single scrolling\n"
	"textline. Each username is followed by number of logins and idle status\n",
	"if it is enabled both enclosed in brackets.\n",
	"If the user's idle is less than 10 minutes his status remains active.\n",
	"If his idle resides between 10 and 30 minutes he is marked as 'away'.\n",
	"In the other case he is supposed to be 'gone'.\n\n",
	"<h>Configuration:\n\n",
	"In the `General' and `Idle status' tabs you may set up the following parameters:\n",
	"<ul>hide user 'user'",
	" - this is the switch that hides the current user\n\n",
	"<ul>show only users' names",
	" - this is the switch that turns off any additional information\n",
	"<ul>sort users by idle status",
	" - users will be sorted by idle status so that 'active' ones will go first,\n",
	"then 'away' and then 'gone'\n",
	"<ul>sort users by name",
	" - users will be sorted by their login names\n",
	"in the scrolling line\n\n",
	"<ul>scrolling speed",
	" - defines the amount of pixels which the line is moving by\n",
	"<ul>update frequency (sec)",
	" - defines how often the information is updated\n",
	"<ul>show users' idle status",
	" - this is the switch that enables showing idle\n",
	"status (act, away and gone)\n",
	"<ul>away time (sec)",
	" - defines the amount of time in seconds after which the\n",
	"user is marked 'away'\n",
	"<ul>gone time (sec)",
	" - defines the amount of time in seconds after which the\n",
	"'away' user is marked 'gone'\n",
	"<ul>act, away and gone colors",
	"colors for each idle status\n\n",
	"<ul>execute notification command once",
	"command is executed only once at a time even if more than one users\n",
	"has changed status\n\n",
	"<ul>notification command",
	"command to be executed when some user changes status\n\n",
	"<h>Disclaimer:\n\n",
	"This plugin was inspired by the 'who' plugin for gkrellm as done by\n",
	"Ernesto Novillo <ernie@cs.ualberta.ca> that obviously seemed to have\n",
	"no port for gkrellm2. After all I had a few ideas those were not done\n",
	"in the mentioned software and I've released some of them here.\n",
	"Feel free to send me any bugs/complaints/ideas to:\n",
	"<i>shisha@shisha.spb.ru\n\n",
	"<h>Thanks:\n\n",
	"I'd like to thank following people for any kinds of help:\n",
	"Konstantin Starodubtsev, Alexander Luzgarev, Bill Wilson,\n",
	"Michael Sibiryakov, Daniel Gebhart, Otavio Salvador.\n"
};

gchar About[] = 
	"GKrellmWHO2 Version 0.2.8 (GKrellm2)\n"\
	"Plugin displays currently logged in users in a coloured scrolling line.\n\n"\
	"Copyright (c) 2003 by Alexander Shishckin\n"\
	"Release Date: 15/08/2003\n"\
	"shisha@shisha.spb.ru\n"\
	"http://shisha.spb.ru/projects/GkrellmWHO2/\n\n"\
	"Released under the GNU Public License.\n";

#endif

